/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.global.GuiQuestEdit;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class GuiNPCManageQuest
extends GuiNPCInterface2
implements ISubGuiListener,
ICustomScrollListener,
GuiYesNoCallback {
    public static GuiScreen Instance;
    private final TreeMap<String, QuestCategory> categoryData = new TreeMap();
    private final Map<String, Quest> questData = new LinkedHashMap<String, Quest>();
    private GuiCustomScroll scrollCategories;
    private GuiCustomScroll scrollQuests;
    private static boolean isName;
    private String selectedCategory = "";
    private String selectedQuest = "";
    private Quest copyQuest = null;

    public GuiNPCManageQuest(EntityNPCInterface npc) {
        super(npc);
        Instance = this;
        Client.sendData(EnumPacketServer.QuestCategoryGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 1: {
                this.setSubGui(new SubGuiEditText(1, Util.instance.deleteColor(new TextComponentTranslation("gui.new", new Object[0]).func_150254_d())));
                break;
            }
            case 2: {
                if (!this.categoryData.containsKey(this.selectedCategory)) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, this.categoryData.get((Object)this.selectedCategory).title, new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 2);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 3: {
                if (!this.categoryData.containsKey(this.selectedCategory)) {
                    return;
                }
                this.setSubGui(new SubGuiEditText(3, this.categoryData.get((Object)this.selectedCategory).title));
                break;
            }
            case 9: {
                if (this.copyQuest == null || !this.categoryData.containsKey(this.selectedCategory)) {
                    return;
                }
                Quest quest = this.copyQuest.copy();
                quest.id = -1;
                quest.category = this.categoryData.get(this.selectedCategory);
                StringBuilder t = new StringBuilder(quest.title);
                boolean has = true;
                while (has) {
                    has = false;
                    for (Quest q : quest.category.quests.values()) {
                        if (quest.id == q.id || !q.title.equalsIgnoreCase(t.toString())) continue;
                        has = true;
                        break;
                    }
                    if (!has) continue;
                    t.append("_");
                }
                quest.setName(t.toString());
                this.selectedQuest = this.getKey(quest);
                Client.sendData(EnumPacketServer.QuestSave, quest.category.id, quest.save(new NBTTagCompound()));
                this.func_73866_w_();
                break;
            }
            case 10: {
                if (!this.questData.containsKey(this.selectedQuest)) {
                    return;
                }
                this.copyQuest = this.questData.get(this.selectedQuest);
                this.func_73866_w_();
                break;
            }
            case 11: {
                this.setSubGui(new SubGuiEditText(11, Util.instance.deleteColor(new TextComponentTranslation("gui.new", new Object[0]).func_150254_d())));
                break;
            }
            case 12: {
                if (!this.questData.containsKey(this.selectedQuest)) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, this.questData.get(this.selectedQuest).getTitle(), new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 12);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 13: {
                if (!this.questData.containsKey(this.selectedQuest)) {
                    return;
                }
                this.setSubGui(new GuiQuestEdit(this.questData.get(this.selectedQuest)));
                break;
            }
            case 14: {
                isName = ((GuiNpcCheckBox)button).isSelected();
                button.setHoverText("hover.sort", new TextComponentTranslation("dialog.dialogs", new Object[0]).func_150254_d(), ((GuiNpcCheckBox)button).getText());
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    public void func_73878_a(boolean result, int id) {
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
        if (!result) {
            return;
        }
        if (id == 2) {
            Client.sendData(EnumPacketServer.QuestCategoryRemove, this.categoryData.get((Object)this.selectedCategory).id);
            this.selectedCategory = "";
            this.selectedQuest = "";
        }
        if (id == 12) {
            Client.sendData(EnumPacketServer.QuestRemove, this.questData.get((Object)this.selectedQuest).id);
            this.selectedQuest = "";
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hasSubGui()) {
            return;
        }
        this.func_73730_a(this.guiLeft + 348, this.guiLeft + 414, this.guiTop + 128, new Color(Integer.MIN_VALUE).getRGB());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_73866_w_() {
        void var4_20;
        void var4_17;
        super.func_73866_w_();
        this.categoryData.clear();
        this.questData.clear();
        QuestController qData = QuestController.instance;
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        for (QuestCategory questCategory : qData.categories.values()) {
            this.categoryData.put(questCategory.title, questCategory);
            if (!this.selectedCategory.isEmpty()) continue;
            this.selectedCategory = questCategory.title;
        }
        if (!this.selectedCategory.isEmpty()) {
            if (this.categoryData.containsKey(this.selectedCategory)) {
                TreeMap<String, Quest> map = new TreeMap<String, Quest>();
                for (Quest quest : this.categoryData.get((Object)this.selectedCategory).quests.values()) {
                    map.put(this.getKey(quest), quest);
                }
                List<Map.Entry<String, Quest>> list = GuiNPCManageQuest.getEntryList(map);
                for (Map.Entry<String, Quest> entry : list) {
                    this.questData.put(entry.getKey(), entry.getValue());
                    if (!this.selectedQuest.isEmpty()) continue;
                    this.selectedQuest = entry.getKey();
                }
            } else {
                this.selectedCategory = "";
                this.selectedQuest = "";
            }
            if (!this.questData.isEmpty()) {
                int pos = 0;
                DialogController dialogController = DialogController.instance;
                for (Quest quest : this.questData.values()) {
                    hts.put(pos++, this.getStrings(quest, qData, dialogController));
                }
            }
        }
        if (!this.selectedCategory.isEmpty() && !this.categoryData.containsKey(this.selectedCategory)) {
            this.selectedCategory = "";
        }
        if (!this.selectedQuest.isEmpty() && !this.questData.containsKey(this.selectedQuest)) {
            this.selectedQuest = "";
        }
        this.addLabel(new GuiNpcLabel(0, "gui.categories", this.guiLeft + 8, this.guiTop + 4));
        this.addLabel(new GuiNpcLabel(1, "quest.quests", this.guiLeft + 180, this.guiTop + 4));
        int x = this.guiLeft + 350;
        int n = this.guiTop + 8;
        this.addLabel(new GuiNpcLabel(3, "quest.quests", this.guiLeft + 356, this.guiTop + 8));
        GuiNpcButton guiNpcButton = new GuiNpcButton(13, x, (int)(var4_13 += 10), 64, 15, "selectServer.edit", !this.selectedQuest.isEmpty());
        guiNpcButton.setHoverText("manager.hover.quest.edit", this.selectedQuest);
        this.addButton(guiNpcButton);
        GuiNpcButton guiNpcButton2 = new GuiNpcButton(12, x, (int)(var4_14 += 17), 64, 15, "gui.remove", !this.selectedQuest.isEmpty());
        guiNpcButton2.setHoverText("manager.hover.quest.del", this.selectedQuest);
        this.addButton(guiNpcButton2);
        GuiNpcButton guiNpcButton3 = new GuiNpcButton(11, x, (int)(var4_15 += 17), 64, 15, "gui.add", !this.selectedCategory.isEmpty());
        guiNpcButton3.setHoverText("manager.hover.quest.add", this.selectedCategory);
        this.addButton(guiNpcButton3);
        GuiNpcButton guiNpcButton4 = new GuiNpcButton(10, x, (int)(var4_16 += 21), 64, 15, "gui.copy", !this.selectedCategory.isEmpty());
        guiNpcButton4.setEnabled(!this.selectedQuest.isEmpty());
        guiNpcButton4.setHoverText("manager.hover.quest.copy", this.selectedQuest);
        this.addButton(guiNpcButton4);
        GuiNpcButton guiNpcButton5 = new GuiNpcButton(9, x, (int)(var4_17 += 17), 64, 15, "gui.paste", this.copyQuest != null);
        guiNpcButton5.setHoverText("manager.hover.quest.paste." + (this.copyQuest != null), this.copyQuest != null ? this.copyQuest.getKey() : "");
        this.addButton(guiNpcButton5);
        GuiNpcCheckBox guiNpcCheckBox = new GuiNpcCheckBox(14, x, (int)(var4_17 + 17), 64, 14, "gui.name", "ID", isName);
        guiNpcCheckBox.setHoverText("hover.sort", new TextComponentTranslation("dialog.dialogs", new Object[0]).func_150254_d(), guiNpcCheckBox.getText());
        this.addButton(guiNpcCheckBox);
        int n2 = this.guiTop + 134;
        this.addLabel(new GuiNpcLabel(2, "gui.categories", x + 2, n2));
        GuiNpcButton guiNpcButton6 = new GuiNpcButton(3, x, (int)(var4_19 += 10), 64, 15, "selectServer.edit", !this.selectedCategory.isEmpty());
        guiNpcButton6.setHoverText("manager.hover.category.edit", new Object[0]);
        this.addButton(guiNpcButton6);
        GuiNpcButton guiNpcButton7 = new GuiNpcButton(2, x, (int)(var4_20 += 17), 64, 15, "gui.remove", !this.selectedCategory.isEmpty());
        guiNpcButton7.setHoverText("manager.hover.category.del", new Object[0]);
        this.addButton(guiNpcButton7);
        GuiNpcButton guiNpcButton8 = new GuiNpcButton(1, x, (int)(var4_20 + 17), 64, 15, "gui.add");
        guiNpcButton8.setHoverText("manager.hover.category.add", new Object[0]);
        this.addButton(guiNpcButton8);
        if (this.scrollCategories == null) {
            this.scrollCategories = new GuiCustomScroll(this, 0);
            this.scrollCategories.setSize(170, this.ySize - 3);
        }
        this.scrollCategories.setList(new ArrayList<String>(this.categoryData.keySet()));
        this.scrollCategories.guiLeft = this.guiLeft + 4;
        this.scrollCategories.guiTop = this.guiTop + 15;
        if (!this.selectedCategory.isEmpty()) {
            this.scrollCategories.setSelected(this.selectedCategory);
        }
        this.addScroll(this.scrollCategories);
        if (this.scrollQuests == null) {
            this.scrollQuests = new GuiCustomScroll(this, 1);
            this.scrollQuests.setSize(170, this.ySize - 3);
        }
        this.scrollQuests.setListNotSorted(new ArrayList<String>(this.questData.keySet()));
        this.scrollQuests.setHoverTexts(hts);
        this.scrollQuests.guiLeft = this.guiLeft + 176;
        this.scrollQuests.guiTop = this.guiTop + 15;
        if (!this.selectedQuest.isEmpty()) {
            this.scrollQuests.setSelected(this.selectedQuest);
        }
        this.addScroll(this.scrollQuests);
    }

    private static List<Map.Entry<String, Quest>> getEntryList(Map<String, Quest> map) {
        ArrayList<Map.Entry<String, Quest>> list = new ArrayList<Map.Entry<String, Quest>>(map.entrySet());
        list.sort((d_0, d_1) -> {
            if (isName) {
                String n_0 = Util.instance.deleteColor(new TextComponentTranslation(((Quest)d_0.getValue()).title, new Object[0]).func_150254_d() + "_" + ((Quest)d_0.getValue()).id).toLowerCase();
                String n_1 = Util.instance.deleteColor(new TextComponentTranslation(((Quest)d_1.getValue()).title, new Object[0]).func_150254_d() + "_" + ((Quest)d_1.getValue()).id).toLowerCase();
                return n_0.compareTo(n_1);
            }
            return Integer.compare(((Quest)d_0.getValue()).id, ((Quest)d_1.getValue()).id);
        });
        return list;
    }

    private String getKey(Quest quest) {
        boolean b = quest.isSetUp();
        return "\u00a77ID:" + quest.id + "-\"" + '\u00a7' + "r" + quest.getTitle() + '\u00a7' + "7\"" + '\u00a7' + (b ? "2 (" : "c (") + new TextComponentTranslation("quest.has." + b, new Object[0]).func_150254_d() + '\u00a7' + (b ? "2)" : "c)");
    }

    private List<String> getStrings(Quest quest, QuestController qData, DialogController dData) {
        ArrayList<String> h = new ArrayList<String>();
        ArrayList<String> quests = new ArrayList<String>();
        ArrayList<String> dialogs = new ArrayList<String>();
        h.add(new TextComponentTranslation(quest.title, new Object[0]).func_150254_d() + ":");
        for (Quest q : qData.quests.values()) {
            if (q.nextQuest != quest.id) continue;
            quests.add("\u00a77ID:" + q.id + '\u00a7' + "8 " + q.category.getName() + "/" + '\u00a7' + "r" + q.getName());
        }
        for (Dialog d : dData.dialogs.values()) {
            if (d.quest != quest.id) continue;
            dialogs.add("\u00a77ID:" + d.id + '\u00a7' + "8 " + d.category.getName() + "/" + '\u00a7' + "r" + d.getName());
        }
        if (quests.isEmpty() && dialogs.isEmpty()) {
            h.add(new TextComponentTranslation("quest.hover.quest.0", new Object[0]).func_150254_d());
        }
        if (!quests.isEmpty()) {
            h.add(new TextComponentTranslation("quest.hover.in.quests", new Object[0]).func_150254_d());
            h.addAll(quests);
        } else {
            h.add(new TextComponentTranslation("quest.hover.quest.1", new Object[0]).func_150254_d());
        }
        if (!dialogs.isEmpty()) {
            h.add(new TextComponentTranslation("quest.hover.in.dialogs", new Object[0]).func_150254_d());
            h.addAll(dialogs);
        } else {
            h.add(new TextComponentTranslation("quest.hover.quest.2", new Object[0]).func_150254_d());
        }
        return h;
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuGlobal);
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void save() {
        GuiNpcTextField.unfocus();
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (!scroll.hasSelected()) {
            return;
        }
        if (scroll.getID() == 0) {
            if (this.selectedCategory.equals(scroll.getSelected())) {
                return;
            }
            this.selectedCategory = scroll.getSelected();
            this.selectedQuest = "";
            this.scrollQuests.setSelect(-1);
        }
        if (scroll.getID() == 1) {
            if (this.selectedQuest.equals(scroll.getSelected())) {
                return;
            }
            this.selectedQuest = scroll.getSelected();
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        if (!this.selectedQuest.isEmpty() && scroll.getID() == 1) {
            this.setSubGui(new GuiQuestEdit(this.questData.get(this.selectedQuest)));
        } else if (!this.selectedCategory.isEmpty() && scroll.getID() == 0) {
            this.setSubGui(new SubGuiEditText(3, this.categoryData.get((Object)this.selectedCategory).title));
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiEditText && !((SubGuiEditText)subgui).cancelled) {
            boolean has;
            StringBuilder t;
            QuestCategory category;
            if (subgui.getId() == 1) {
                category = new QuestCategory();
                t = new StringBuilder(((SubGuiEditText)subgui).text[0]);
                has = true;
                while (has) {
                    has = false;
                    for (QuestCategory cat : QuestController.instance.categories.values()) {
                        if (cat.id == category.id || !cat.title.equalsIgnoreCase(t.toString())) continue;
                        has = true;
                        break;
                    }
                    if (!has) continue;
                    t.append("_");
                }
                this.selectedCategory = category.title = t.toString();
                Client.sendData(EnumPacketServer.QuestCategorySave, category.save(new NBTTagCompound()));
                this.func_73866_w_();
            }
            if (subgui.getId() == 3) {
                if (((SubGuiEditText)subgui).text[0].isEmpty() || !this.categoryData.containsKey(this.selectedCategory)) {
                    return;
                }
                category = this.categoryData.get(this.selectedCategory).copy();
                if (category.title.equals(((SubGuiEditText)subgui).text[0])) {
                    return;
                }
                t = new StringBuilder(((SubGuiEditText)subgui).text[0]);
                has = true;
                while (has) {
                    has = false;
                    for (QuestCategory cat : QuestController.instance.categories.values()) {
                        if (cat.id == category.id || !cat.title.equalsIgnoreCase(t.toString())) continue;
                        has = true;
                        break;
                    }
                    if (!has) continue;
                    t.append("_");
                }
                this.selectedCategory = category.title = t.toString();
                Client.sendData(EnumPacketServer.QuestCategorySave, category.save(new NBTTagCompound()));
                this.func_73866_w_();
            }
            if (subgui.getId() == 11) {
                if (((SubGuiEditText)subgui).text[0].isEmpty()) {
                    return;
                }
                Quest quest = new Quest(this.categoryData.get(this.selectedCategory));
                t = new StringBuilder(((SubGuiEditText)subgui).text[0]);
                has = true;
                while (has) {
                    has = false;
                    for (Quest q : quest.category.quests.values()) {
                        if (quest.id == q.id || !q.title.equalsIgnoreCase(t.toString())) continue;
                        has = true;
                        break;
                    }
                    if (!has) continue;
                    t.append("_");
                }
                quest.setName(t.toString());
                this.selectedQuest = this.getKey(quest);
                Client.sendData(EnumPacketServer.QuestSave, this.categoryData.get((Object)this.selectedCategory).id, quest.save(new NBTTagCompound()));
                this.func_73866_w_();
            }
        }
        if (subgui instanceof GuiQuestEdit) {
            this.func_73866_w_();
        }
    }

    static {
        isName = true;
    }
}

